-- Messaging for Application Follow Up Event (warner Sprint)

SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='APPOINTMENT');
INSERT INTO `system_msg_event` 
(`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`,`uiDisplayCode`) 
VALUES (@systemmsgeventId+1, '1', @msgSubCategoryId, 'APPLICATION_FOLLOW_UP', 'Application Follow Up', 'SYSTEM', 0, 0, 0, 0, 1, 0, 0, 'Application Follow Up','Application Follow Up');


SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`) 
VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');


SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);


SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EXTRA_PARAMS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

-- Template data provider for the Appointment

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'APPLICATION_FOLLOW_UP_DL', 'SQL');

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'APPLICATION_FOLLOW_UP_RECIPIENT', 'SQL');

SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICATION_FOLLOW_UP_RECIPIENT');
INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'APPLICATION_FOLLOW_UP_RECIPIENT');


SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICATION_FOLLOW_UP_DL');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='APPLICATION_FOLLOW_UP_RECIPIENT');
INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`) 
VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);



-- Setting the query for the Applicant distribution list

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICATION_FOLLOW_UP_DL');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId, "SELECT 
    T1.id AS USER_ID
FROM
    application_followup T1
WHERE
    T1.id IN (namedParams)",NULL);


-- Setting the query for the User Recipient

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICATION_FOLLOW_UP_RECIPIENT');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"SELECT 
    T1.id AS ID,
    T3.firstName AS FIRST_NAME,
    T3.lastName AS LAST_NAME,
    T3.emailId AS EMAIL_ID,
    T3.mobileNumber AS MOBILE_NO,
    T4.code AS APPLICATION_CODE,
    T5.firstName AS APPLICANT_FIRST_NAME,
     T4.applicationCreatedOn AS APPLICATION_DATE,
     (CASE
        WHEN
            T4.currentStatus IS NOT NULL
                AND T4.currentStatus = 'APPLIED'
        THEN
            'Applied'
        WHEN
            T4.currentStatus IS NOT NULL
                AND T4.currentStatus = 'NOT_APPLIED'
        THEN
            'Not Applied'
        WHEN
            T4.currentStatus IS NOT NULL
                AND T4.currentStatus = 'SOLD'
        THEN
            'Sold'
        WHEN
            T4.currentStatus IS NOT NULL
                AND T4.currentStatus = 'SUBMITTED'
        THEN
            'Submitted'
        WHEN
            T4.currentStatus IS NOT NULL
                AND T4.currentStatus = 'APPROVED'
        THEN
            'Approved'
        WHEN
            T4.currentStatus IS NOT NULL
                AND T4.currentStatus = 'REJECTED'
        THEN
            'Rejected'
        WHEN
            T4.currentStatus IS NOT NULL
                AND T4.currentStatus = 'WITHDRAWN'
        THEN
            'Withdrawn'
        WHEN
            T4.currentStatus IS NOT NULL
                AND T4.currentStatus = 'CLOSED'
        THEN
            'Closed'
        WHEN
            T4.currentStatus IS NOT NULL
                AND T4.currentStatus = 'DIRECT_ADMISSION'
        THEN
            'Direct Admission'
        WHEN
            T4.currentStatus IS NOT NULL
                AND T4.currentStatus = 'MID_TERM_ADMISSION'
        THEN
            'Mid term admission'
        WHEN
            T4.currentStatus IS NOT NULL
                AND T4.currentStatus = 'DIRECT_SUBMISSION_TOKEN_GENERATED'
        THEN
            'Direct submission token generated'
        WHEN
            T4.currentStatus IS NOT NULL
                AND T4.currentStatus = 'FORM_SALE_TOKEN_GENERATED'
        THEN
            'Form sale token generated'
        WHEN
            T4.currentStatus IS NOT NULL
                AND T4.currentStatus = 'NOT_SUBMITTED'
        THEN
            'Not Submitted'
        WHEN
            T4.currentStatus IS NOT NULL
                AND T4.currentStatus = 'ADMISSION_GRANTED'
        THEN
            'Admission granted'
        ELSE ''
    END) AS APPLICATION_STATUS,
    (CASE
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'OFFER_LETTER_ACCEPTED'
        THEN
            'Offer letter accepted'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'OFFER_LETTER_ISSUED'
        THEN
            'Offer letter issued'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'OFFER_LETTER_REJECTED'
        THEN
            'Offer letter rejected'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'OFFER_LETTER_DUE'
        THEN
            'Offer letter due'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'ACTIVE'
        THEN
            'Active'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'APPROVED'
        THEN
            'Approved'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'ADMITTED'
        THEN
            'Admitted'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'ADMITTED_ON_TRIAL'
        THEN
            'Admitted on trial'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'ADMITTED_ON_PROVISIONAL'
        THEN
            'Admitted on provisional'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'REJECTED'
        THEN
            'Rejected'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'WITHDRAWN'
        THEN
            'Withdrawn'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'WITHDRAW_AFTER_ACCEPTING_OFFER_LETTER'
        THEN
            'Withdrawn after accepting offer letter'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'CLOSED'
        THEN
            'Closed'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'PROVISIONAL_OFFER_ISSUED'
        THEN
            'Provisional offer issued'
            WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'PROVISIONAL_OFFER_REJECTED'
        THEN
            'Provisional offer rejected'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'PROVISIONAL_OFFER_DUE'
        THEN
            'Provisional offer due'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'OFFER_EXPIRED'
        THEN
            'Offer Expired'
            WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'PROVISIONAL_OFFER_EXPIRED'
        THEN
            'Provisional Offer Expired'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'ESCALATED'
        THEN
            'Escalated'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'ESCALATED_OFFER_REVIEWED'
        THEN
            'Escalated Offer Reviewed'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'WAITING_LIST'
        THEN
            'Waiting List'  
        ELSE ''
    END) AS OFFER_STATUS,
    T11.academyName AS ACADEMY_NAME,
    T11.locationName AS LOCATION_NAME,
    T11.displayName AS ACADEMY_NAME_LOCATION,
    T7.`programNameToBePrint` AS PROGRAM_NAME,
    T9.`printName` AS BATCH_PRINT_NAME,
    T10.`seatName` AS SEAT_TYPE,
    T11.id AS ACADEMY_LOCATION_ID,
    T11.academyId AS ACADEMY_ID,
    (CASE
        WHEN
            T11.headerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T11.headerUrl)
        ELSE NULL
    END) AS HEADER_URL,
    (CASE
        WHEN
            T11.footerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T11.footerUrl)
        ELSE NULL
    END) AS FOOTER_URL,
	(CASE
        WHEN
            T11.logoUrl IS NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl,
                    '/',
                    'emailer/images/logo_default_image.png')
        WHEN
            T11.logoUrl IS NULL
                AND org.orgUrl IS NULL
        THEN
            'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(org.orgUrl, '/', T11.logoUrl)
    END) AS LOGO_URL,
     GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID
FROM
    application_followup T1
    left join staffs T2 on T2.userId=T1.assignTo
    left join persons T3 on T3.id=T2.personId
    LEFT JOIN application T4 on T4.id=T1.applicationId
    left join applicant_person T5 on T5.id=T4.applicantPersonId
    left join application_program T6 on T6.applicationId=T4.id
    left join programs T7 on T7.id=T6.programId
    left join prog_batch_seat_config T8 on T8.id=T6.progBatchSeatConfigId
    left join batches T9 on T9.id=T8.programBatchId
    left join seat_types T10 on T10.id=T8.seatTypeId
    left join academy_location T11 ON T11.id = T6.academyLocationId 
       LEFT JOIN
    `fire_base_persons_info` f ON f.userId = T2.personId
    LEFT OUTER JOIN
    organizations org ON org.id = (SELECT 
            MAX(id)
        FROM
            organizations)
    where T1.id in (namedParams) group by T1.assignTo",'{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "firstName",
            "resultKey": "APPLICANT_FIRST_NAME",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "code",
            "resultKey": "APPLICATION_CODE",
            "displayCode": "",
            "displayOrder": 4
        },
        {
            "id": 6,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 5
        },
        {
            "id": 7,
            "value": "locationName",
            "resultKey": "LOCATION_NAME",
            "displayCode": "",
            "displayOrder": 6
        },
        {
            "id": 8,
            "value": "programName",
            "resultKey": "PROGRAM_NAME",
            "displayCode": "",
            "displayOrder": 7
        },
        {
            "id": 9,
            "value": "batchPrintName",
            "resultKey": "BATCH_PRINT_NAME",
            "displayCode": "",
            "displayOrder": 8
        },
        {
            "id": 10,
            "value": "seatType",
            "resultKey": "SEAT_TYPE",
            "displayCode": "",
            "displayOrder": 9
        },
        {
            "id": 11,
            "value": "applicationStatus",
            "resultKey": "APPLICATION_STATUS",
            "displayCode": "",
            "displayOrder": 10
        },
        {
            "id": 12,
            "value": "offerStatus",
            "resultKey": "OFFER_STATUS",
            "displayCode": "",
            "displayOrder": 11
        },
        {
            "id": 13,
            "value": "applicationDate",
            "resultKey": "APPLICATION_DATE",
            "displayCode": "",
            "displayOrder": 12
        },
        {
            "id": 14,
            "value": "logoURL",
            "resultKey": "LOGO_URL",
            "displayCode": "",
            "displayOrder": 13
        },
        {
            "id": 15,
            "value": "headerUrl",
            "resultKey": "HEADER_URL",
            "displayCode": "",
            "displayOrder": 14
        },
        {
            "id": 16,
            "value": "footerUrl",
            "resultKey": "FOOTER_URL",
            "displayCode": "",
            "displayOrder": 15
        },
        {
            "id": 17,
            "value": "academyLocationId",
            "resultKey": "ACADEMY_LOCATION_ID",
            "displayCode": "",
            "displayOrder": 16
        },
        {
            "id": 18,
            "value": "academyId",
            "resultKey": "ACADEMY_ID",
            "displayCode": "",
            "displayOrder": 17
        }

    ]
}');


SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='APPLICATION_FOLLOW_UP');

SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='APPOINTMENT');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='APPLICATION_FOLLOW_UP_RECIPIENT');
SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');


INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`) 
VALUES(@msgtemplateconfigId+1,'Application Follow Up',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,NULL,NULL,'Application Follow Up',NULL,'',NULL,'','APPROVED','','1','System Admin','1');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','Application Follow Up Assignment','<html>
<head>
    <title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
    <tbody>
        <tr style="background-color:#f0f0f0; line-height:20px;">
            <td style="padding:20px 20px 20px 20px;">
             <p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Dear <strong>$recipientData[&quot;FIRST_NAME&quot;]</strong> <strong>$recipientData[&quot;LAST_NAME&quot;]</strong> , </br>Follow-up to Application No. <strong>$recipientData[&quot;APPLICATION_CODE&quot;]</strong> is assigned to you.</p>
            </td>
        </tr>
        <tr>
            <td align="center" style="margin:0px; padding:0px;"><img height="80" width="100%" src="$recipientData[&quot;FOOTER_URL&quot;]" /></td>
        </tr>
    </tbody>
</table>
</body>
</html>');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES(@msgtemplateId+2,@msgtemplateconfigId+1,'2',NULL,'
Dear $recipientData["FIRST_NAME"] $recipientData["LAST_NAME"] ,
Follow-up to Application No. $recipientData["APPLICATION_CODE"] is assigned to you.');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+3,@msgtemplateconfigId+1,'4','Application Follow Up Assignment','<html>
<head>
    <title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
    <tbody>
        <tr style="background-color:#f0f0f0; line-height:20px;">
            <td style="padding:20px 20px 20px 20px;">
             <p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Dear <strong>$recipientData[&quot;FIRST_NAME&quot;]</strong> <strong>$recipientData[&quot;LAST_NAME&quot;]</strong> , </br>Follow-up to Application No. <strong>$recipientData[&quot;APPLICATION_CODE&quot;]</strong> is assigned to you.</p>
            </td>
        </tr>
        <tr>
            <td align="center" style="margin:0px; padding:0px;"><img height="80" width="100%" src="$recipientData[&quot;FOOTER_URL&quot;]" /></td>
        </tr>
    </tbody>
</table>
</body>
</html>');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+4,@msgtemplateconfigId+1,'6','Application Follow Up Assignment','<html>
<head>
    <title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
    <tbody>
        <tr style="background-color:#f0f0f0; line-height:20px;">
            <td style="padding:20px 20px 20px 20px;">
             <p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Dear <strong>$recipientData[&quot;FIRST_NAME&quot;]</strong> <strong>$recipientData[&quot;LAST_NAME&quot;]</strong> , </br>Follow-up to Application No. <strong>$recipientData[&quot;APPLICATION_CODE&quot;]</strong> is assigned to you.</p>
            </td>
        </tr>
        <tr>
            <td align="center" style="margin:0px; padding:0px;"><img height="80" width="100%" src="$recipientData[&quot;FOOTER_URL&quot;]" /></td>
        </tr>
    </tbody>
</table>
</body>
</html>');

set sql_safe_updates=0;
update msg_template_config set templatelanguageValue= 'English' where templatelanguageValue is null;
update msg_template_config set whetherEnabled=1 where whetherEnabled is null;
set sql_safe_updates=1;

-- End Messaging for Application Follow Up Event 
